;/**********************************************************
; Program		:16x2 LCD Display
; CPU Control	:90S8535
; File name		:lcd.asm
; Assembler		:AVR Studio 4.05
; LCD pin information :RESET=PC2, ENABLE=PC3, DATA=PC7-PC4
;***********************************************************

.include "8535def.inc"			

			.org   $000 
    		rjmp  reset					;Reset Handle

;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		temp1		= r18
.def		temp		= r19
.def		data		= r20
.def		counter3	= r22
.equ		PORT_LCD	= PORTC
.equ		DDR_LCD		= DDRC
.equ		PIN_LCD		= PINC
.equ		EN_LCD		= 3
.equ		RES_LCD		= 2

;/*******************
; Main Program
;/*******************

reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          		;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	
;/*******************************************
; Initialize LCD before send any data to it.
;/*******************************************
main:		rcall	delay30ms
			ser	temp
			out	DDR_LCD,temp
			ldi	temp,0b00110000
			out	PORT_LCD,temp
			ldi	counter3,3
loop_init:	sbi	PORT_LCD,EN_LCD
	     	cbi	PORT_LCD,EN_LCD
			rcall	delay1ms
			dec	counter3
			brne	loop_init
			cbi	PORT_LCD,4
			sbi	PORT_LCD,EN_LCD
			cbi	PORT_LCD,EN_LCD
			rcall	delay1ms
            rcall   init_lcd          	;init LCD

;/**************************************
; Display first line from left to right
;/**************************************
Start_Display:	
			ldi	data,0x06				;increment address mode
			rcall	wr_ins
			ldi     data,0x80			;DD RAM address 00h
	        rcall   wr_ins  
	     	ldi     ZH,high(TEXT1*2)		
	     	ldi     ZL,low(TEXT1*2)		;init pointer		
Display_to_Right:
	     	lpm							;get data
	     	tst	r0
			breq	End_to_Right
			mov     data,r0     		
	     	rcall	wr_data
			rcall	delay200ms
			adiw    ZL,1				;increment Z-pointer
			brne	Display_to_Right
End_to_Right:

;/*****************************************
; Display second line from right to left
;/*****************************************	
			ldi	data,0x04				;decrement address mode
			rcall	wr_ins
			ldi	data,0xCF				;DD RAM address 4F
			rcall	wr_ins
			ldi	ZH,high(TEXT2*2)
			ldi	ZL,low(TEXT2*2)			;init pointer
			adiw	ZL,15				;increment ZL
Display_to_Left:
			lpm							;get data
	     	tst	r0
			breq	End_to_Left
			mov	data,r0
			rcall	wr_data
			rcall	delay200ms
	     	sbiw    ZL,1				;decrement Z-pointer
			brne	Display_to_Left
End_to_Left:

			rcall	delay1s
			rcall	Display_ON_OFF

;/******************************
; shift left all 2 line,16 time
;/******************************
			ldi	counter3,16
Shift_Left:	ldi	data,0x18				;shift left
			rcall	wr_ins
			rcall	delay200ms
			dec	counter3
			brne	Shift_Left
			rcall	delay1s

;/**********************************
; shift right all 2 line ,32 time
;/**********************************

Shift_Right:	
			ldi	counter3,2
sfr1:		push	counter3
			ldi	counter3,16
sfr2:		ldi	data,0x1C				;shift right
			rcall	wr_ins
			rcall	delay200ms
			dec	counter3
			brne	sfr2
			rcall	delay1s
			pop	counter3
			dec	counter3			
			brne	sfr1
			rcall	init_lcd			;init lcd
			rjmp	Start_Display		;begin again
	
;/*****************************
; sub routine display ON / OFF
;/*****************************
Display_ON:	ldi	data,0x0C
			rcall	wr_ins
			ret

Display_OFF:	
			ldi	data,0x08
			rcall	wr_ins
			ret

Clear_Display:	
			ldi	data,0x01
			rcall	wr_ins
			ret

Display_ON_OFF:
			ldi	counter3,5
sub_ON_OFF:	rcall	Display_OFF
			rcall	delay200ms
			rcall	Display_ON
			rcall	delay200ms
			dec	counter3
			brne	sub_ON_OFF
			rcall	delay1s
			ret

;/*******************
; Initial LCD
;/*******************

init_lcd:	ldi     data,0x28             	;4 bit,2 line,5x7 dot
            rcall   wr_ins                       
            ldi     data,0x0C				;ON Display,OFF Cursor
            rcall   wr_ins
            ldi     data,0x06              	;increment DD RAM Adress by 1
            rcall   wr_ins 
            ldi     data,0x01				;reset LCD
            rcall   wr_ins 
            ret

wr_ins:		cbi	PORT_LCD,RES_LCD
			rcall	delay1ms
			rcall	wr_dat
			ret
wr_data:	sbi	PORT_LCD,RES_LCD
			rcall	delay1ms
			rcall	wr_dat
			ret

;/************************************
; write Command and Data 8 bit 
;*************************************
wr_dat:		ldi     counter1,2
	     	mov     temp,data			;reserve data        
wr_dat1:    push	temp
			andi    data,0xF0			;clear 4 bit low
			clr	temp1
			out	DDR_LCD,temp1
            in      temp,PIN_LCD
			ser	temp1
			out	DDR_LCD,temp1
            andi    temp,0x0F			;clear 4 bit high
            or      data,temp                             
            out     PORT_LCD,data       ;send data out     
	     	rcall   enable_lcd			;LCD receive 4 bit data 
            dec     counter1
			breq	end_wr
			pop	temp		
            swap    temp				;next 4 bit data low 
	     	mov     data,temp
			rjmp	wr_dat1	     	
end_wr:		pop	temp
			ret
	
;/********************************
; Enable LCD                               
; Rising edge to ENABLE LCD pin
;*********************************  
enable_lcd: sbi     PORT_LCD,EN_LCD     ;rising edge
            rcall   delay1ms
            cbi     PORT_LCD,EN_LCD		;falling edge
	     	rcall   delay1ms
            ret

;/*****************
; delay time
;/*****************
delay1ms:	push	counter1
			push	counter2
			ldi    	counter1,8
delay1ms_1: ldi    	counter2,250
delay1ms_2: nop
			dec    	counter2
            brne   	delay1ms_2
            dec    	counter1
            brne   	delay1ms_1
            pop	counter2
			pop	counter1
			ret          

delay30ms:	push	counter1
			push	counter2
			ldi    	counter1,240
delay30ms_1:   	
			ldi    	counter2,250
delay30ms_2:   	
			nop
			dec    	counter2
            brne   	delay30ms_2
            dec    	counter1
            brne   	delay30ms_1
            pop	counter2
			pop	counter1
			ret          

delay200ms:	push	counter3
			ldi	counter3,200
delay200ms_1:	
			rcall	delay1ms
			dec	counter3
			brne	delay200ms_1
			pop	counter3
			ret

delay1s:	push	counter3
			ldi	counter3,30
delay1s_1:	rcall	delay30ms
			dec	counter3
			brne	delay1s_1
			pop	counter3
			ret

;/******************
; code segment
;/******************

TEXT1:		.db	"WELCOME TO ETT.",0
TEXT2:		.db	"CP-MEGA/AVR V2.0",0
